/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/12bI
 */

package
{
    import flash.display.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.utils.*;
    import flash.events.*;
    import net.hires.debug.Stats;
 
    /**
    *   An app to test the speed of BitmapData objects with and without alpha
    *   @author Jackson Dunstan
    */
    [SWF(frameRate=60)]
    public class BitmapDataAlphaTest extends Sprite
    {
        private var logger:TextField = new TextField();
 
        public function BitmapDataAlphaTest ()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
 
            logger.autoSize = TextFieldAutoSize.LEFT;
            addChild(logger);
            addChild(new Stats());
 
            addEventListener(Event.ENTER_FRAME, testLight);
        }
 
        private function log(msg:*): void { logger.appendText(msg + "\n"); }
 
        private function testLight(ev:Event): void
        {
            removeEventListener(Event.ENTER_FRAME, testLight);
 
            var i:int;
            const NUM_ITERATIONS:int = 1000000;
            var beforeTime:int;
 
            var bmdAlpha:BitmapData = new BitmapData(5, 5, true);
            var bmdNoAlpha:BitmapData = new BitmapData(3, 3, false);
            var bmdBuffer:BitmapData = new BitmapData(3, 3, false);
 
            var rect:Rectangle = new Rectangle(0, 0, 3, 3);
            var dest:Point = new Point(5, 5);
            var blurFilter:BlurFilter = new BlurFilter();
 
            log("Light: (" + NUM_ITERATIONS + " iterations)");
 
            log("\tAlpha:");
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.floodFill(0, 0, 0xff000000);
            }
            log("\t\tfloodFill: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.generateFilterRect(rect, blurFilter);
            }
            log("\t\tgenerateFilterRect: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.getColorBoundsRect(0x00000000, 0x00000000);
            }
            log("\t\tgetColorBoundsRect: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.getPixel(0, 0);
            }
            log("\t\tgetPixel: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.getPixel32(0, 0);
            }
            log("\t\tgetPixel32: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.scroll(0, 0);
            }
            log("\t\tscroll: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.setPixel(0, 0, 0xff000000);
            }
            log("\t\tsetPixel: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.setPixel32(0, 0, 0xff000000);
            }
            log("\t\tsetPixel32: " + (getTimer()-beforeTime));
 
            log("\tNo Alpha:");
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.floodFill(0, 0, 0xff000000);
            }
            log("\t\tfloodFill: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.generateFilterRect(rect, blurFilter);
            }
            log("\t\tgenerateFilterRect: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.getColorBoundsRect(0x00000000, 0x00000000);
            }
            log("\t\tgetColorBoundsRect: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.getPixel(0, 0);
            }
            log("\t\tgetPixel: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.getPixel32(0, 0);
            }
            log("\t\tgetPixel32: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.scroll(0, 0);
            }
            log("\t\tscroll: " + (getTimer()-beforeTime));
 
            //bmdNoAlpha.lock();
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                //
                bmdNoAlpha.setPixel(0, 0, 0xff000000);
                //
            }
            log("\t\tsetPixel: " + (getTimer()-beforeTime));
            //bmdNoAlpha.unlock();
            
            bmdNoAlpha.lock();
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.setPixel32(0, 0, 0xff000000);
            }
            log("\t\tsetPixel32: " + (getTimer()-beforeTime));
            bmdNoAlpha.unlock(); 
            
            addEventListener(Event.ENTER_FRAME, testHeavy);
        }
 
        private function testHeavy(ev:Event): void
        {
            removeEventListener(Event.ENTER_FRAME, testHeavy);
 
            var i:int;
            const NUM_ITERATIONS:int = 1000000;
            var beforeTime:int;
 
            var bmdAlpha:BitmapData = new BitmapData(5, 5, true);
            var bmdNoAlpha:BitmapData = new BitmapData(200, 120, false);
            var bmdBuffer:BitmapData = new BitmapData(5, 5, false);
 
            var rect:Rectangle = new Rectangle(0, 0, 200, 120);
            var dest:Point = new Point(5, 5);
            var colorTransform:ColorTransform = new ColorTransform();
            var byteArray:ByteArray = new ByteArray();
            var vec:Vector.<uint> = new Vector.<uint>(1000*1000, true);
            for (i = 0; i < 1000*1000; ++i)
            {
                byteArray.writeUnsignedInt(0xff000000);
                vec[i] = 0xff000000;
            }
 
            log("Heavy: (" + NUM_ITERATIONS + " iterations)");
 
            log("\tAlpha:");
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.colorTransform(rect, colorTransform);
            }
            log("\t\tcolorTransform: " + (getTimer()-beforeTime));
 
            //beforeTime = getTimer();
            //for (i = 0; i < NUM_ITERATIONS; ++i)
            //{
            //    bmdAlpha.clone();
            //}
            //log("\t\tclone: " + (getTimer()-beforeTime));
 
            bmdAlpha.lock();
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.fillRect(rect, 0x000000);
            }
            bmdAlpha.unlock();
            log("\t\tfillRect: " + (getTimer()-beforeTime));
            
    
            //beforeTime = getTimer();
            //for (i = 0; i < NUM_ITERATIONS; ++i)
            //{
            //     bmdAlpha.getPixels(rect);
            //}
            //log("\t\tgetPixels: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.getVector(rect);
            }
            log("\t\tgetVector: " + (getTimer()-beforeTime));
 
            //beforeTime = getTimer();
            //for (i = 0; i < NUM_ITERATIONS; ++i)
            //{
            //    bmdAlpha.histogram(rect);
            //}
            //log("\t\thistogram: " + (getTimer()-beforeTime));
 
            //beforeTime = getTimer();
            //for (i = 0; i < NUM_ITERATIONS; ++i)
            //{
            //    bmdAlpha.noise(33);
            //}
            //log("\t\tnoise: " + (getTimer()-beforeTime));
 
            //beforeTime = getTimer();
            //for (i = 0; i < NUM_ITERATIONS; ++i)
            //{
            //    bmdAlpha.perlinNoise(64, 128, 1, 33, false, false);
            //}
            //log("\t\tperlinNoise: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                byteArray.position = 0;
                bmdAlpha.setPixels(rect, byteArray);
            }
            log("\t\tsetPixels: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdAlpha.setVector(rect, vec);
            }
            log("\t\tsetVector: " + (getTimer()-beforeTime));
 
            log("\tNo Alpha:");
 
            bmdNoAlpha.lock();
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.colorTransform(rect, colorTransform);
            }
            bmdNoAlpha.unlock();
            log("\t\tcolorTransform: " + (getTimer()-beforeTime));
 
            //beforeTime = getTimer();
            //for (i = 0; i < NUM_ITERATIONS; ++i)
            //{
            //    bmdNoAlpha.clone();
            //}
            //log("\t\tclone: " + (getTimer()-beforeTime));
 
            bmdNoAlpha.lock();
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.fillRect(rect, 0xff000000);
            }
            bmdNoAlpha.unlock();
            log("\t\tfillRect: " + (getTimer()-beforeTime));
 
            //beforeTime = getTimer();
            //for (i = 0; i < NUM_ITERATIONS; ++i)
            //{
            //    bmdNoAlpha.getPixels(rect);
            //}
            //log("\t\tgetPixels: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.getVector(rect);
            }
            log("\t\tgetVector: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            /*for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.histogram(rect);
            }
            log("\t\thistogram: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.noise(33);
            }
            log("\t\tnoise: " + (getTimer()-beforeTime));
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.perlinNoise(64, 128, 1, 33, false, false);
            }
            log("\t\tperlinNoise: " + (getTimer()-beforeTime));*/
 
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                byteArray.position = 0;
                bmdNoAlpha.setPixels(rect, byteArray);
            }
            log("\t\tsetPixels: " + (getTimer()-beforeTime));
 
            bmdNoAlpha.lock();
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
                bmdNoAlpha.setVector(rect, vec);
            }
            bmdNoAlpha.unlock();
            log("\t\tsetVector: " + (getTimer()-beforeTime));
            
            bmdBuffer.lock();
            beforeTime = getTimer();
            for (i = 0; i < NUM_ITERATIONS; ++i)
            {
               bmdBuffer.copyPixels(bmdNoAlpha, rect, dest);
            }
            bmdBuffer.unlock();
            log("\t\tcopyPixels: " + (getTimer()-beforeTime));
        }
    }
}