/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/12Sw
 */

// forked from jondissed's forked from: Implicit 3D Blobby
// forked from shapevent's Implicit 3D Blobby
package {
    import flash.text.TextFormat;
    import flash.text.TextField;

        // interactive implicit 3D blobby plot
        
        // more info here: http://actionsnippet.com/?p=1318
        
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;


    
       [SWF(backgroundColor=0x000000)]
       
       public class ImplicitBlobby extends MovieClip {
        private var matrix:Matrix3D;
        private var verts:Vector.<Number>;
        private var pVerts:Vector.<Number>;
        private var uvts:Vector.<Number>;
        private var s:Number;
        private var brush:BitmapData;
        private var canvas:BitmapData;
        private var dx:Number;
        private var dy:Number;


               public function ImplicitBlobby(){
                  // init
            matrix = new Matrix3D();
            verts = new Vector.<Number>();
            pVerts = new Vector.<Number>();
            uvts = new Vector.<Number>();
            var count:int=0;
            for (var i:Number = -12; i<=12; i+=.04*19) {
                for (var j:Number = -12; j<=12; j+=.04*19) {
                    for (var k:Number = -12; k<=12; k+=.04*19) {
                        // blobby, from here www.iiit.net/techreports/ImplicitTR.pdf
            s=Math.sqrt(i*i+j*j+k*k)-10;
                        if (s<=0 && s>-1) {
                            ++count;
                            verts.push(i * 12);
                            verts.push(j * 12);
                            verts.push(k * 12);
                            pVerts.push(0),pVerts.push(0);
                            uvts.push(0),uvts.push(0),uvts.push(0);
                        }
                    }
                }
            }
            trace("count: "+count);
            var tf:TextField=new TextField();
            tf.opaqueBackground=0xFFFFFF;
            tf.defaultTextFormat=new TextFormat("serif",14,0x777777);
            tf.width=100;
            tf.height=25;
            tf.x=10;
            tf.y=10;
            tf.text=("count: "+count);
            this.addChild(tf);
            brush=new BitmapData(4,4,true,0x41FFFFFF);
            var c:uint=0x4100EE33;
            var d:uint=0x4133FFAA;
            brush.setVector(new Rectangle(0,0,4,4), Vector.<uint>([
               d,c,c,d, c,0,0,c, c,0,0,c, d,c,c,d
               ]));
            canvas=new BitmapData(400,400,false,0x000000);
            addChild(new Bitmap(canvas));
            dx=0;
            dy=0;
            addEventListener(Event.ENTER_FRAME, onLoop);
            

               }
               // private methods

        private function onLoop(evt:Event):void {
            dx += (mouseX - dx)/4;
            dy += (mouseY - dy)/4;
            matrix.identity();
            matrix.appendRotation(dy,Vector3D.X_AXIS);
            matrix.appendRotation(dx,Vector3D.Y_AXIS);
            matrix.appendTranslation(200, 200, 0);
            Utils3D.projectVectors(matrix, verts, pVerts, uvts);
            canvas.lock();
            canvas.fillRect(canvas.rect, 0x000000);
            var p:Point = new Point();
            for (var i:int = 0; i<pVerts.length; i+=2) {
                p.x = pVerts[i];
                p.y = pVerts[i+1];
                canvas.copyPixels(brush, brush.rect, p, null, null, true);
            }
            canvas.unlock();
        }
        

       }

}