/**
 * Copyright lagash ( http://wonderfl.net/user/lagash )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/12Ql
 */

package {
    import flash.display.Sprite;
	import flash.display.*;
	import flash.events.*;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldAutoSize;
	import org.papervision3d.core.math.Number3D;
	
	import flash.net.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.utils.*;
	
	import flash.text.Font;

	import org.papervision3d.materials.special.*;
	import org.papervision3d.lights.*;
	import org.papervision3d.events.*;

	import org.papervision3d.cameras.*;  
	import org.papervision3d.render.BasicRenderEngine;  
	import org.papervision3d.scenes.Scene3D;  
	import org.papervision3d.view.Viewport3D;  
	import org.papervision3d.objects.*;  
	import org.papervision3d.objects.primitives.*  
	import org.papervision3d.materials.*;  
	import org.papervision3d.materials.shadematerials.*; 
	import org.papervision3d.materials.shaders.*;
	import org.papervision3d.materials.utils.*;  
    
    
    
    public class FlashTest extends Sprite {
        
  		private var viewport :Viewport3D;  
		private var scene        :Scene3D;  
		private var camera       :Camera3D;  
		private var renderer :BasicRenderEngine;  
		private var sphere       :Sphere;  

                private var container:Sprite;

      public function FlashTest() {
            // write as3 code here..
            container = new Sprite();
            addChild(container);
            //container.graphics.beginFill(0x000000,1);
            //container.graphics.drawCircle(50,50,30);
            //container.width=container.height=200;
            container.x=container.y=100;            
            init3D();
        }
        
      private function init3D():void {
			
	// ビューポートの作成
	this.viewport = new Viewport3D(200, 200,false, true);
	//viewport.visible=false;
	container.addChild( viewport );

	//レンダラーの設定
	this.renderer = new BasicRenderEngine();
		
	//シーン作成
	this.scene = new Scene3D();
	
	//ライトの作成
	var light:PointLight3D = new PointLight3D();
           light.x = 300;
            light.y = 500;
            light.z = -1000;
            
            //ライトを追加
            this.scene.addChild(light);
            
            
            //テクスチャーの作成
 //           var texture:BitmapData = new earth_texture(0,0); 
            var texture:BitmapData = new BitmapData(100,100,true,0xFF00FFFF);
            
            //ビットマップマテリアル
            var bit_mat:BitmapMaterial = new BitmapMaterial(texture,true);
 //           var bit_mat:WireframeMaterial = new WireframeMaterial(0xFF00FF,1, 0);
 //          var bit_mat: ColorMaterial= new ColorMaterial(0xFF00FF,1,false);
            
            //phong shaderの作成 PhongShader(ライト , ライト色 , 環境色 , スペキュラの強さ , バンプマップ , スペキュラマップ)
			//var phong_shader:PhongShader = new PhongShader(light ,0xFFFFFF , 0xaaaaaa,1,null,null);
			//var phong_shader:GouraudShader = new GouraudShader(light ,0xFFFFFF , 0xaaaaaa,1);
			var phong_shader:FlatShader = new FlatShader(light ,0x000000 , 0x8bc8f0,0);
			
			
			//球体を作成
			this.sphere = new Sphere(new ShadedMaterial(bit_mat, phong_shader), 90, 16, 16);
			//sphere.x = 0;//220;
			//sphere.y = 0;//-55;
			sphere.rotationZ = -10;
			
			
			//平面シーンに追加
			this.scene.addChild(this.sphere);
			
			
			
			// カメラの作成
			camera = new Camera3D();
			camera.x = 0;
			camera.y = 0;
			camera.zoom = 50;
			camera.focus = 100;
			camera.z = -(camera.focus * camera.zoom - camera.focus);
			
			//trace(camera.z);
			
			this.renderer.renderScene(scene, camera, viewport);


			
		}
		
       
        
        
        
        
    }
}