/**
 * Copyright meemeer ( http://wonderfl.net/user/meemeer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/128pk
 */

/*

evangelionのシンクログラフ風
やっつけ

参考
http://active.tutsplus.com/tutorials/effects/create-a-retro-crt-distortion-effect-using-rgb-shifting/
*/

package {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.BlendMode;
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.easing.*;
	
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0x000000")]
	
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
			stage.align = StageAlign.TOP_LEFT;
			stage.quality = StageQuality.HIGH;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			var sp1:Sprite = new Sprite();
			sp1.graphics.lineStyle(2.5, 0xffffff);
			sp1.graphics.moveTo(-stage.stageWidth, stage.stageHeight / 2);
			sp1.graphics.curveTo( -(stage.stageWidth / 4) * 3, 0, -stage.stageWidth / 2, stage.stageHeight / 2);
			sp1.graphics.curveTo( -(stage.stageWidth / 4), stage.stageHeight, 0, stage.stageHeight / 2);
			sp1.graphics.curveTo((stage.stageWidth / 4), 0, stage.stageWidth / 2, stage.stageHeight / 2);
			sp1.graphics.curveTo((stage.stageWidth / 4) * 3, stage.stageHeight, stage.stageWidth, stage.stageHeight / 2);
			sp1.graphics.curveTo(stage.stageWidth + (stage.stageWidth / 4), 0, stage.stageWidth + (stage.stageWidth / 2), stage.stageHeight / 2);
			sp1.graphics.curveTo(stage.stageWidth + (stage.stageWidth / 4) * 3, stage.stageHeight, stage.stageWidth * 2, stage.stageHeight / 2)

			var sp2:Sprite = new Sprite();
			sp2.graphics.lineStyle(2.5, 0xffffff);
			sp2.graphics.moveTo(-stage.stageWidth, stage.stageHeight / 2 - 30);
			sp2.graphics.curveTo( -(stage.stageWidth / 4) * 3, 0, -stage.stageWidth / 2, stage.stageHeight / 2 - 30);
			sp2.graphics.curveTo( -(stage.stageWidth / 4), stage.stageHeight, 0, stage.stageHeight / 2 - 30);
			sp2.graphics.curveTo((stage.stageWidth / 4), 0, stage.stageWidth / 2, stage.stageHeight / 2 - 30);
			sp2.graphics.curveTo((stage.stageWidth / 4) * 3, stage.stageHeight, stage.stageWidth, stage.stageHeight / 2 - 30);
			sp2.graphics.curveTo(stage.stageWidth + (stage.stageWidth / 4), 0, stage.stageWidth + (stage.stageWidth / 2), stage.stageHeight / 2 - 30);
			sp2.graphics.curveTo(stage.stageWidth + (stage.stageWidth / 4) * 3, stage.stageHeight, stage.stageWidth * 2, stage.stageHeight / 2 - 30)
			
			var inner:Sprite = new Sprite();
			inner.addChild(sp1);
			inner.addChild(sp2);
			inner.filters = [new BlurFilter(3, 3)];
			
			var bmd:BitmapData = new BitmapData(stage.stageWidth * 3, stage.stageHeight, true, 0x0);
			bmd.draw(inner);
			
			var wrap:Sprite = new Sprite();
			for (var i:int = 0; i < 7; i++ ) {
				var bm:Bitmap = new Bitmap(bmd);
				wrap.addChild(bm);
				bm.x = -stage.stageWidth / 2 + (40 * i);
			}
			
			var rgbBMD:Array = createRGB(wrap);
			rgbBMD.forEach(function(rgb:BitmapData, i:int, a:Array):void {
				var b:Bitmap = new Bitmap(rgb);
				b.smoothing = true;
				b.blendMode = BlendMode.SCREEN;
				
				var container:Sprite = new Sprite();
				container.addChild(b);
				
				addChild(container);
				effect(container);
			} );
			
			makeInfo();
            
        }
        
		private function effect(img:Sprite):void
		{
			var tween:ITween = BetweenAS3.tween(img, {
				x:randRange( -stage.stageWidth / 4 - 50, -stage.stageWidth / 4  + 50)
			}, randRange(4, 5) / 10);
			tween.onComplete = function():void {
				effect(img);
			}
			tween.play();
		}
		
		private function randRange(min:int, max:int):int
		{
			var randomNum:int = Math.floor(Math.random() * (max - min + 1)) + min;
			return randomNum;
		}
		
		private function createBMD(dObj:DisplayObject):BitmapData
		{
			var bmd:BitmapData = new BitmapData(dObj.width, dObj.height, true, 0xff000000);
			bmd.draw(dObj);
			return bmd;
		}
		
		private function createRGB(dObj:DisplayObject):Array
		{
			var bmd:BitmapData = createBMD(dObj);
			
			var r:BitmapData = new BitmapData(bmd.width, bmd.height, true, 0xff000000);
			var g:BitmapData = new BitmapData(bmd.width, bmd.height, true, 0xff000000);
			var b:BitmapData = new BitmapData(bmd.width, bmd.height, true, 0xff000000);
			
			r.copyChannel(bmd, bmd.rect, new Point(), BitmapDataChannel.RED, BitmapDataChannel.RED);
			g.copyChannel(bmd, bmd.rect, new Point(), BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
			b.copyChannel(bmd, bmd.rect, new Point(), BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
			
			return [r, g, b];
		}
		
		private function makeInfo():void
		{
			var info:Sprite = new Sprite();
			addChild(info);
			info.graphics.lineStyle(2, 0xffffff);
			
			for (var i:Number = 0; i <= stage.stageWidth; i += stage.stageWidth / 4 ) {
				for (var j:Number = 0; j < stage.stageHeight; j += stage.stageWidth / 4 ) {
					drawLine(i, j - 10, i, j + 10, info);
					drawLine(i - 10, j, i + 10, j, info);
				}
			}
			
			info.graphics.lineStyle(4, 0xffffff);
			drawLine(0, stage.stageHeight - 40, stage.stageWidth, stage.stageHeight - 40, info);
			
			for (var k:Number = 0; k < 20; k++ ) {
				if (k % 2) {
					drawLine(stage.stageWidth / 20 * k, stage.stageHeight - 40, stage.stageWidth / 20 * k, stage.stageHeight - 40 + 10, info);
				} else {
					var tf:TextField = new TextField();
					tf.defaultTextFormat = new TextFormat('_typewriter', 20, 0xffffff);
					tf.text = String(k - 10);
					addChild(tf);
					tf.x = stage.stageWidth / 20 * k - tf.textWidth / 2;
					tf.y = stage.stageHeight - 15;
					drawLine(stage.stageWidth / 20 * k, stage.stageHeight - 40, stage.stageWidth / 20 * k, stage.stageHeight - 40 + 20, info);
				}
			}
		}
		
		private function drawLine(x:Number, y:Number, xx:Number, yy:Number, sp:Sprite):void
		{
			sp.graphics.moveTo(x, y);
			sp.graphics.lineTo(xx, yy);
		}
    }
}