/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/123b
 */

// forked from fluxus's forked from: forked from: forked from: forked from: シーン遷移 (2)
// forked from fluxus's forked from: forked from: forked from: シーン遷移 (2)
// forked from fluxus's forked from: forked from: シーン遷移 (2)
// forked from fluxus's forked from: シーン遷移 (2)
// forked from ProjectNya's シーン遷移 (2)
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] シーン遷移に挑戦！ (2)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1332
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.MouseEvent;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var menus:Array;
        private var scenes:Array;
        private static var max:uint = 5;
        private var sceneId:uint = 0;
        private var transited:uint = 0;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            var labels:Array = new Array();
            labels.push("ABOUT ME");
            labels.push("PHOTOGRAPHS");
            labels.push("ACRYLS");
            labels.push("PROJECTS");
            labels.push("CONTACT");
            var bases:Array = new Array();
            bases.push(0x999999);
            bases.push(0x999999);
            bases.push(0x999999);
            bases.push(0x999999);
            bases.push(0x999999);
            var lights:Array = new Array();
            lights.push([0xFFFFFF, 0x999999]);
            lights.push([0x00FFFF, 0x3333FF]);
            lights.push([0x99FF00, 0x33CC00]);
            lights.push([0xFFFF00, 0xFFCC00]);
            lights.push([0xFFCCFF, 0xFF66CC]);
            var colors:Array = new Array();
            colors.push(0xFFFFFF);
            colors.push(0xFFFFFF);
            colors.push(0xFFFFFF);
            colors.push(0xFFFFFF);
            colors.push(0xFFFFFF);
            menus = new Array();
            scenes = new Array();
            //
            var container:Sprite = new Sprite();
            addChild(container);
            container.x = 5;
            container.y = 110;
            var overlay:Shape = new Shape();
            overlay.graphics.beginFill(0x000000);
            overlay.graphics.drawRect(0, 0, 455, 300);
            overlay.graphics.endFill();
            overlay.x = 5;
            overlay.y = 110;
            container.mask = overlay;
            //
            var scene0:Index = new Index(colors[0], labels[0]);
            container.addChild(scene0);
            scenes.push(scene0);
            var scene1:Scene1 = new Scene1(colors[1], labels[1]);
            container.addChild(scene1);
            scenes.push(scene1);
            var scene2:Scene2 = new Scene2(colors[2], labels[2]);
            container.addChild(scene2);
            scenes.push(scene2);
            var scene3:Scene3 = new Scene3(colors[3], labels[3]);
            container.addChild(scene3);
            scenes.push(scene3);
            var scene4:Scene4 = new Scene4(colors[4], labels[4]);
            container.addChild(scene4);
            scenes.push(scene4);
            //
            for (var n:uint = 0; n < max; n++) {
                var menu:ActionMenu = new ActionMenu();
                menu.x = 50 + 5*uint(n > 0) + 90*n;
                menu.y = 80;
                addChild(menu);
                menu.init({id: n, label: labels[n], width: 80});
                menu.colorize(bases[n], lights[n]);
                menu.addEventListener(MouseEvent.CLICK, select, false, 0, true);
                menus.push(menu);
                var scene:Sprite = scenes[n];
                scene.addEventListener(CompoEvent.CLOSED, closed, false, 0, true);
                scene.addEventListener(CompoEvent.OPENED, opened, false, 0, true);
            }
            manage();
            scene0.start();
        }
        private function select(evt:MouseEvent):void {
            transit(evt.target.id);
        }
        private function transit(id:uint):void {
            if (id == sceneId) return;
            sceneId = id;
            manage();
            transited = 0;
            for (var n:uint = 0; n < max; n++) {
                var scene:IScene = scenes[n];
                scene.close();
            }
        }
        private function closed(evt:CompoEvent):void {
            transited ++;
            if (transited > max - 1) {
                reset();
                var scene:IScene = scenes[sceneId];
                scene.open();
            }
        }
        private function opened(evt:CompoEvent):void {
            var scene:IScene = scenes[evt.value];
            scene.start();
        }
        private function reset():void {
            for (var n:uint = 0; n < max; n++) {
                var scene:IScene = scenes[n];
                scene.reset();
            }
        }
        private function manage():void {
            for (var n:uint = 0; n < max; n++) {
                var menu:ActionMenu = menus[n];
                menu.selected = (n == sceneId);
            }
        }
        
    }

}


//////////////////////////////////////////////////
// ActionMenuクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;

class ActionMenu extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var base:Shape;
    private var front:Shape;
    private var light:Shape;
    private var overlay:Shape;
    private var txt:TextField;
    private var label:String = "";
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 60;
    private static var _height:uint = 32;
    private static var corner:uint = 6;
    private static var tHeight:uint = 17;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var baseColor:uint = 0x0066CC;
    private static var lightColor:uint = 0x00FFFF;
    private static var overColor:uint = 0x3333FF;
    private static var lights:Array = [lightColor, overColor];
    private static var tColor:uint = 0xFFFFFF;
    private static var defaultColorTrans:ColorTransform;
    private static var disableColor:uint = 0xCCCCCC;
    private static var disableColorTrans:ColorTransform;
    private var mode:int;
    private static var unit:Number = 0.1;
    private var _selected:Boolean = false;
    private var _enabled:Boolean = true;

    public function ActionMenu() {
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.label != undefined) label = option.label;
        if (option.width != undefined) _width = option.width;
        draw();
    }
    private function draw():void {
        defaultColorTrans = new ColorTransform();
        disableColorTrans = new ColorTransform();
        disableColorTrans.color = disableColor;
        shade = new Shape();
        base = new Shape();
        front = new Shape();
        light = new Shape();
        overlay = new Shape();
        txt = new TextField();
        addChild(shade);
        addChild(base);
        addChild(front);
        addChild(light);
        addChild(overlay);
        addChild(txt);
        createBase(shade, _width, _height, corner, bColor);
        shade.filters = [new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false)];
        //createBase(base, _width-2, _height-2, corner, baseColor);
        //createFront(front, _width, _height, corner);
        //createLight(light, _width-2, _height-2, corner);
        createOverlay(overlay, _width-2, _height-2, corner);
        txt.x = -_width/2;
        txt.y = -tHeight + _height/4;
        txt.width = _width;
        txt.height = tHeight;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 10;
        tf.align = TextFormatAlign.CENTER;
        txt.defaultTextFormat = tf;
        txt.textColor = tColor;
        txt.text = label;
        txt.filters = [new DropShadowFilter(0, 90, sColor, 0.5, 2, 2, 2, 3, false, false)];
        light.alpha = 0;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent = null):void {
        mode = 1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function rollOut(evt:MouseEvent = null):void {
        mode = -1;
        addEventListener(Event.ENTER_FRAME, action, false, 0, true);
    }
    private function action(evt:Event):void {
        light.alpha += unit*mode;
        if (light.alpha < 0) {
            light.alpha = 0;
            removeEventListener(Event.ENTER_FRAME, action);
        }
        if (light.alpha > 1) {
            light.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, action);
        }
    }
    private function _up():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
    }
    private function _down():void {
        base.transform.colorTransform = defaultColorTrans;
        front.transform.colorTransform = defaultColorTrans;
        light.alpha = 1;
    }
    private function _disable():void {
        base.transform.colorTransform = disableColorTrans;
        front.transform.colorTransform = disableColorTrans;
    }
    public function get selected():Boolean {
        return _selected;
    }
    public function set selected(param:Boolean):void {
        _selected = param;
        enabled = !_selected;
        if (_selected) {
            _down();
        } else {
            _up();
            rollOut();
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
        } else {
            _disable();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
        }
    }
    public function colorize(c:uint, list:Array):void {
        baseColor = c;
        lights = list;
        createBase(base, _width-2, _height-2, corner, baseColor);
        createFront(front, _width, _height, corner);
        createLight(light, _width-2, _height-2, corner);
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createFront(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = [baseColor, baseColor];
        var alphas:Array = [0, 0.5];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w, h, 0.5*Math.PI, -w/2, -h/2);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createLight(target:Shape, w:uint, h:uint, c:uint):void {
        var colors:Array = lights;
        var alphas:Array = [1, 0];
        var ratios:Array = [40, 160];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w*2, h*3, 0, -w, -h*0.9);
        target.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        target.graphics.endFill();
    }
    private function createOverlay(target:Shape, w:uint, h:uint, c:uint):void {
        target.graphics.beginFill(bColor, 0.3);
        target.graphics.drawEllipse(-w*1.125, -h*4.375, w*2.25, h*4.375);
        target.graphics.endFill();
        var _mask:Shape = new Shape();
        _mask.graphics.beginFill(sColor);
        _mask.graphics.drawRoundRect(-w/2, -h/2, w, h, c*2);
        _mask.graphics.endFill();
        addChild(_mask);
        target.mask = _mask;
    }

}


//////////////////////////////////////////////////
// ISceneインターフェイス
//////////////////////////////////////////////////

interface IScene {

    function start():void;
    function reset():void;
    function open():void;
    function close():void;
    function enable(useful:Boolean):void;

}


//////////////////////////////////////////////////
// Indexクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Index extends Sprite implements IScene {
    public var cid:uint = 0;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;
    private var logo:Label;

    public function Index(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 300);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 135;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        logo = new Label(200, 30, 20, Label.CENTER);
        base.addChild(logo);
        logo.x = 132;
        logo.y = 135;
        logo.textColor = 0xFFFFFF;
        logo.text = "merdreierworks";
        base.alpha = 1;
        base.visible = true;
        label.alpha = 1;
        label.visible = true;
        logo.alpha = 0;
        logo.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5), 
            BetweenAS3.delay(BetweenAS3.to(logo, {alpha: 1, visible: 1}, 0.4, Linear.easeNone), 0.2)
        );
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
    }
    public function reset():void {
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {alpha: 1, visible: 1}, 0.4, Linear.easeNone), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.parallel(
                BetweenAS3.to(logo, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
                BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone)
            ), 
            BetweenAS3.to(base, {alpha: 0, visible: 0}, 0.3, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Scene1クラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Scene1 extends Sprite implements IScene {
    public var cid:uint = 1;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;

    public function Scene1(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 300);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 135;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        base.y = - 300;
        label.alpha = 0;
        label.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5);
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
    }
    public function reset():void {
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {y: 0}, 0.4, Quad.easeOut), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(base, {y: - 300}, 0.3, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Scene2クラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Scene2 extends Sprite implements IScene {
    public var cid:uint = 2;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;

    public function Scene2(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 300);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 135;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        base.x = - 455;
        label.alpha = 0;
        label.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5);
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
    }
    public function reset():void {
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {x: 0}, 0.4, Quad.easeOut), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(base, {x: - 455}, 0.3, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Scene3クラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Scene3 extends Sprite implements IScene {
    public var cid:uint = 3;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;

    public function Scene3(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 300);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 135;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        base.x = 455;
        label.alpha = 0;
        label.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5);
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
    }
    public function reset():void {
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {x: 0}, 0.4, Quad.easeOut), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(base, {x: 455}, 0.3, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Scene4クラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.easing.*;

class Scene4 extends Sprite implements IScene {
    public var cid:uint = 4;
    private var tweens:Array;
    private var color:uint = 0x000000;
    private var base:Sprite;
    private var label:Label;
    private var txt:String;

    public function Scene4(c:uint, t:String = "") {
        color = c;
        txt = t;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        tweens = new Array();
        base = new Sprite();
        addChild(base);
        base.graphics.beginFill(color);
        base.graphics.drawRect(0, 0, 455, 300);
        base.graphics.endFill();
        label = new Label(100, 30, 20, Label.CENTER);
        base.addChild(label);
        label.x = 182;
        label.y = 135;
        label.textColor = 0xFFFFFF;
        label.text = txt;
        base.y = 300;
        label.alpha = 0;
        label.visible = false;
    }
    public function start():void {
        var itween:ITween = BetweenAS3.delay(BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 0.5);
        itween.addEventListener(TweenEvent.COMPLETE, setup, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function setup(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, setup);
    }
    public function reset():void {
    }
    public function open():void {
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(base, {y: 0}, 0.4, Quad.easeOut), 
            BetweenAS3.to(label, {alpha: 1, visible: 1}, 0.4, Linear.easeNone)
        );
        itween.addEventListener(TweenEvent.COMPLETE, opened, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function opened(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, opened);
        dispatchEvent(new CompoEvent(CompoEvent.OPENED, cid));
    }
    public function close():void {
        clear();
        var itween:ITween = BetweenAS3.serial(
            BetweenAS3.to(label, {alpha: 0, visible: 0}, 0.3, Linear.easeNone), 
            BetweenAS3.to(base, {y: 300}, 0.3, Quad.easeOut)
        );
        itween.addEventListener(TweenEvent.COMPLETE, closed, false, 0, true);
        itween.play();
        tweens.push(itween);
    }
    private function closed(evt:TweenEvent):void {
        evt.target.removeEventListener(TweenEvent.COMPLETE, closed);
        dispatchEvent(new CompoEvent(CompoEvent.CLOSED, cid));
    }
    private function clear():void {
        for (var n:uint = 0; n < tweens.length; n++) {
            var itween:ITween = tweens[n];
            itween.stop();
            itween = null;
        }
    }
    public function enable(useful:Boolean):void {
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;
import flash.filters.DropShadowFilter;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 12;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
        filters = [new DropShadowFilter(1, 90, 0x000000, 0.4, 4, 4, 1.5, 3, false, false, false)];
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}


//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const OPENED:String = "opened";
    public static const CLOSED:String = "closed";
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    override public function clone():Event {
        return new CompoEvent(type, value);
    }

}
