/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/11zt
 */

package{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.filters.*;
    import flash.geom.*;
    import org.papervision3d.core.data.UserData;
    import org.papervision3d.core.effects.view.ReflectionView;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.cameras.CameraType;
    import org.papervision3d.view.BasicView;

    [SWF(backgroundColor="0x303030")]
    public class Sample extends ReflectionView {
        private var loader1:Loader;
        private var bmp:Bitmap;
        private var bmpData:BitmapData;
        private var drawing:Boolean = false;
        private var sprite:Sprite = new Sprite();

        Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        public var path:String = "http://assets.wonderfl.net/images/related_images";
        public var filename:String = path+"/e/e9/e9fb/e9fb60f22bc3299e95e5e72b2005f1409fb525ce";

        public function Sample() {
            viewport.interactive = true;
            viewportReflection.filters = [new BlurFilter()];

            loader1 = new Loader();
            loader1.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler1);
            loader1.load(new URLRequest(filename), new LoaderContext(true));        
            
            addEventListener(Event.ENTER_FRAME, update);
        }

        private function compHandler1(e:Event):void {
            bmp = Bitmap(loader1.content);
            bmpData = bmp.bitmapData;
            var material:BitmapMaterial = new BitmapMaterial(bmpData);
            var plane:Plane = new Plane(material, 352, 471, 16, 16);

            material.doubleSided = true;
            material.interactive = true;

            plane.y = 150;
            plane.rotationZ = 60;
            scene.addChild(plane);

            sprite.graphics.lineStyle(5, 0xffff0000);

            plane.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, clicked);
            plane.addEventListener(InteractiveScene3DEvent.OBJECT_MOVE, moved);
            stage.addEventListener(MouseEvent.MOUSE_UP, released);
        }

        public function clicked(event:InteractiveScene3DEvent):void {
            drawing = true;
        }
        public function released(event:MouseEvent):void {
            drawing = false;
        }

        public function moved(event:InteractiveScene3DEvent):void {
            var x:Number = event.x;
            var y:Number = event.y;

            if (drawing) {
                var p:uint = bmpData.getPixel32(event.x, event.y);
                if ((p & 0xff000000) != 0) {
                    sprite.graphics.lineTo(x, y);
                    bmpData.draw(sprite);
                }
            }
            sprite.graphics.moveTo(x, y);
        }

        public function update(e:Event):void {
            camera.target.y = 100;
 
            if (!drawing) {
                var camera_length:Number = 500;
                var c:Number = (mouseX / stage.width - 1 - 0.25) * (Math.PI);
                var d:Number = (mouseY / stage.height + 0.5) * (Math.PI / 2 / 2);
                camera.x = Math.sin(c) * Math.cos(d) * camera_length;
                camera.z = Math.cos(c) * Math.cos(d) * camera_length;
                camera.y = Math.sin(d) * camera_length;
            }
            
            singleRender();
        }
    }
}
