/**
 * Copyright utabi ( http://wonderfl.net/user/utabi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/11oF
 */

// forked from utabi's Drawing Actinia
package {
  
  import flash.display.*; 
  import flash.events.*;
  [SWF(width="465", height="465", frameRate="60")]
  
  public class Main extends Sprite{
     
     private var actinia:Actinia;
     
     public function Main() {
          actinia = new Actinia();
          addChild(actinia);
          actinia.x = 465/2 -100;
          actinia.y = 465/2 -100;
          
          actinia.addEventListener(MouseEvent.MOUSE_OVER,eventMouseOver);
          actinia.addEventListener(MouseEvent.MOUSE_OUT,eventMouseOut);
    }
    private function eventMouseOver(e:MouseEvent):void{
        actinia.activate(25);
    }
    private function eventMouseOut(e:MouseEvent):void{
        actinia.deactivate(0);
    }
  }
}
  
  
  
  import flash.geom.Point;
  import frocessing.display.*;
  
  class Actinia extends F5MovieClip2DBmp{
    
    private var stage_width:Number  = 200;
    private var stage_height:Number = 200;
    private var t:Number = 55;
    private var division:int = 12;
    private var innerRadius:int = 80;
    public var spreading:Number;
    private var targetSpreading:int;
    private var isActive:Boolean = false;
    
    public function Actinia() {
      super();
    }
    
    public function setup():void {
      size( stage_width, stage_height );
      spreading = 0;

      background( 255 );
      //noFill();
      fill(0);
      stroke( 0, .5 );
    }
    
    public function draw():void {
    //if ( isMousePressed )
      
      background(255,1);
      translate( stage_width/2 , stage_height / 2 );
      
      beginShape();
      
      var radiusSine:Number = Math.sin(t*10)*spreading;
      
      for(var i:int =-1; i < division ; i++){
                
          var radianTop:Number = (360/division)*(i+0.5+t) * Math.PI / 180;
          var radianBottom:Number = (360/division)*(i+1+t) * Math.PI / 180;
                
          var topPoint:Point = new Point(
              Math.cos(radianTop)*(radiusSine + innerRadius),
              Math.sin(radianTop)*(radiusSine + innerRadius)
          );
                
          var bottomPoint:Point = new Point(
              Math.cos(radianBottom)*(-radiusSine + innerRadius),
              Math.sin(radianBottom)*(-radiusSine + innerRadius)
          );
                
          curveVertex( topPoint.x, topPoint.y );
          curveVertex( bottomPoint.x, bottomPoint.y );
      }

      curveVertex( 
          Math.cos((360/division)*(.5+t) * Math.PI / 180)*(radiusSine + innerRadius),
          Math.sin((360/division)*(.5+t) * Math.PI / 180)*(radiusSine + innerRadius)
      );

      endShape();
      t += 0.01;
      
      if(targetSpreading > spreading){
          spreading += 0.2;    
      } else if(targetSpreading < spreading){
          spreading -= 0.2;    
      }
     }
     public function activate(sp:int):void{
        isActive = true;
        targetSpreading = sp;
     }
     public function deactivate(sp:int):void{
        isActive = false;
        targetSpreading = sp;
     }
  }