/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/11Ae
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
 
	public class Main extends Sprite
	{
		private var balls:Array = new Array();
		private var score:int = 0;
		private var count:int = 0;
		private var tf:TextField;
		private var gameover:TextField;
 
		public function Main()
		{
			tf = new TextField();
			tf.defaultTextFormat = new TextFormat("_typeWriter", 40, 0x0, true);
			tf.autoSize = "left";
			addChild(tf);
 
			gameover = new TextField();
			gameover.defaultTextFormat = new TextFormat("_typeWriter", 30, 0x0, true);
			gameover.autoSize = "left";
			gameover.text = "START";
			gameover.x = (stage.stageWidth  - gameover.width ) / 2;
			gameover.y = (stage.stageHeight - gameover.height) / 2;
			addChild(gameover);
 
			stage.addEventListener(MouseEvent.CLICK, init);
		}
 
		private function init(event:Event):void
		{
			score = 0;
 
			gameover.visible = false;
			gameover.text = "GAME OVER";
			gameover.x = (stage.stageWidth  - gameover.width ) / 2;
			gameover.y = (stage.stageHeight - gameover.height) / 2;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			stage.addEventListener(Event.MOUSE_LEAVE, end);
 
			for (var i:int = 0; i < balls.length; i++)
			{
				removeChild(balls[i]);
			}
			balls = new Array();
		}
 
		private function end(event:Event = null):void
		{
			gameover.visible = true;
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
 
		private function onEnterFrame(event:Event):void
		{
			if (count++ % 30 == 0)
			{
				var ball:Ball = new Ball();
				ball.x = ball.y = 465;
				addChild(ball);
				balls.push(ball);
			}
 
			for (var i:int = 0; i < balls.length; i++)
			{
				balls[i].move();
				if (balls[i].hitTestPoint(mouseX, mouseY)) end();
			}
 
			tf.text = (++score).toString();
			tf.x = stage.stageWidth - tf.width;
		}
	}
}
 
import flash.display.Sprite;
 
class Ball extends Sprite
{
	public const RADIUS:int = Math.random() * 5 + 5;
	public var vx:int = Math.random() * 5 + 5;
	public var vy:int = Math.random() * 5 + 5;
 
	public function Ball()
	{
		graphics.beginFill(int.MAX_VALUE * Math.random());
		graphics.drawCircle(0, 0, RADIUS);
		graphics.endFill();
	}
 
	public function move():void
	{
		this.x += vx;
		this.y += vy;
 
		if (this.x - RADIUS < 0) this.x = RADIUS, vx = Math.random() * 5 + 5;
		if (this.y - RADIUS < 0) this.y = RADIUS, vy = Math.random() * 5 + 5;
		if (stage.stageWidth  <= this.x + RADIUS) this.x = stage.stageWidth  - RADIUS, vx = -(Math.random() * 5 + 5);
		if (stage.stageHeight <= this.y + RADIUS) this.y = stage.stageHeight - RADIUS, vy = -(Math.random() * 5 + 5);
	}
}
