/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/10hP
 */

package {
    import alternativ7.engine3d.containers.ConflictContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Debug;
    import alternativ7.engine3d.core.MipMapping;
    import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.Sorting;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.objects.Sprite3D;
    import alternativ7.engine3d.primitives.Box;
    
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.ColorTransform;
    import flash.system.Capabilities;
    import flash.ui.Keyboard;
    import flash.filters.GlowFilter;
    import flash.display.BlendMode;
    import alternativ7.engine3d.primitives.Plane;
    import alternativ7.engine3d.core.Clipping;
    import alternativ7.engine3d.core.MouseEvent3D;

    [SWF(backgroundColor="#000000", frameRate="100", width="800", height="600")]
    public class HelloAlternativa3D7 extends Sprite {
        
        private var camera:Camera3D;
        private var controller:SimpleObjectController;
        
        private var anim:Boolean = true;
        private var animObject:Object3D;
        
        private var frame:Sprite = new Sprite();
        
        public function HelloAlternativa3D7() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            
            // Camera
            camera = new Camera3D();
            camera.view = new View(800, 600);
            addChild(camera.view);
            camera.rotationX = -120*Math.PI/180;
            camera.rotationZ = -10*Math.PI/180;
            camera.x = -200;
            camera.y = -1000;
            camera.z = 400;
            
            // Camera controller
            controller = new SimpleObjectController(stage, camera, 200, 3);
            
            // Root object
            var container:ConflictContainer = new ConflictContainer();
            container.resolveByAABB = true;
            container.resolveByOOBB = true;
            
            // Box
            var material:TextureMaterial = new TextureMaterial();
            material.texture = new BitmapData(60, 60, false, 0);
            material.texture.perlinNoise(30, 30, 5, 0, false, true, 6);
            material.repeat = false;
            material.smooth = true;
            var box:Box = new Box(200, 200, 200, 3, 3, 3);
            box.setMaterialToAllFaces(material);
            box.sorting = Sorting.DYNAMIC_BSP;
            box.alpha = 0.6;
            
            // Box 2
            var box2:Box = box.clone() as Box;
            box2.z = -300;
            box2.scaleX = 2;
            box2.scaleY = 2;
            box2.scaleZ = 0.3;
            box2.blendMode = BlendMode.ADD;
            box2.filters = [new GlowFilter(0x00FFFF, 1, 20, 20)];
            
            // Plane
            var material2:TextureMaterial = new TextureMaterial(new BitmapData(800, 800, false, 0));
            material2.texture.perlinNoise(300, 300, 5, 10, false, true, 4);
            material2.mipMapping = MipMapping.PER_PIXEL;
            var plane:Plane = new Plane(800, 800, 10, 10);
            plane.setMaterialToAllFaces(material2);
            plane.sorting = Sorting.NONE;
            plane.clipping = Clipping.FACE_CULLING;
            plane.z = -500;
            
            // Sprite
            var material3:TextureMaterial = new TextureMaterial();
            material3.texture = new BitmapData(140, 140, false, 0);
            material3.texture.perlinNoise(30, 30, 5, 0, false, true, 1);
            material3.mipMapping = MipMapping.OBJECT_DISTANCE;
            material3.resolution = 0.1;
            var sprite:Sprite3D = new Sprite3D(140, 140);
            sprite.material = material3;
            sprite.calculateBounds();
            sprite.rotation = 0.7;
            sprite.z = 200;
            sprite.colorTransform = new ColorTransform(1.2, 1.3, 1);
            
            // Adding
            container.addChild(camera);
            container.addChild(plane);
            container.addChild(box);
            container.addChild(box2);
            container.addChild(sprite);
            
            // View frame
            addChild(frame);
            
            // Mouse events
            camera.view.interactive = true;
            container.addEventListener(MouseEvent3D.MOUSE_WHEEL, onMouseWheel);
            
            // Debug
            camera.debug = true;
            addChild(camera.diagram);
            camera.addToDebug(Debug.BOUNDS, Object3D);
            camera.addToDebug(Debug.EDGES, plane);
            camera.addToDebug(Debug.EDGES, box);
            camera.addToDebug(Debug.EDGES, sprite);
            
            // Info
            var info:TextInfo = new TextInfo();
            info.x = 3;
            info.y = 3;
            info.write("Alternativa3D 7 Test, " + Capabilities.version);
            info.write("WASD, arrows — camera move");
            info.write("Shift — acceleration");
            info.write("Drag — look");
            info.write("Space — on/off animation");
            info.write("Q — quality");
            info.write("Tab — debug mode");
            addChild(info);
            
            onResize();

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            stage.addEventListener(Event.RESIZE, onResize);
            
            animObject = box;
        }

        public function onEnterFrame(e:Event = null):void {
            if (anim && animObject != null) {
                animObject.rotationX += 1*Math.PI/180;
                animObject.rotationY -= 0.5*Math.PI/180;
                animObject.rotationZ += 0.5*Math.PI/180;
            }
            controller.update();
            camera.render();
        }
        
        private function onMouseWheel(e:MouseEvent3D):void {
            if (e.target is Sprite3D) {
                (e.target as Sprite3D).rotation += e.delta/20;
            } else {
                (e.target as Object3D).rotationZ += e.delta/20;
            }
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            switch (e.keyCode) {
                case Keyboard.TAB:
                    camera.debug = !camera.debug;
                    break;
                case Keyboard.ENTER:
                    break;
                case Keyboard.SPACE:
                    anim = !anim;
                    break;
                case 81: // Q
                    if (stage.quality == "HIGH") {
                        stage.quality = StageQuality.LOW;
                    } else {
                        stage.quality = StageQuality.HIGH;
                    } 
                    break;
            }
        }

        public function onResize(e:Event = null):void {
            var pd:Number = 80;
            camera.view.width = stage.stageWidth - pd*2;
            camera.view.height = stage.stageHeight - pd*2;
            camera.view.x = pd;
            camera.view.y = pd;
            
            frame.graphics.clear();
            frame.graphics.beginFill(0x000000, 0.75);
            frame.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            frame.graphics.lineStyle(0, 0x7F7F7F);
            frame.graphics.drawRect(pd, pd, camera.view.width, camera.view.height);
            frame.graphics.endFill();
        }
    }
}

import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class TextInfo extends TextField {

    public function TextInfo() {
        autoSize = TextFieldAutoSize.LEFT;
        selectable = false;
        defaultTextFormat = new TextFormat("Tahoma", 10, 0x7F7F7F); 
    }
    
    public function write(value:String):void {
        appendText(value + "\n");
    }
}