/**
 * Copyright fzmn ( http://wonderfl.net/user/fzmn )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/100e
 */

// forked from checkmate's colin challenge for professionals
/**
 * Create a Flash app using Union Platform,
 * where you can collaborate with more than 4 people online.
 *
 * UnionRamen is an example app,
 * you can write code based on this, or build from scratch.
 *
 * UnionRamen is a multiuser bowl of ramen built on the Union Platform.
 * Press the 'n' key to add naruto to the bowl.
 * For Union Platform documentation, see www.unionplatform.com.
 * 
 * @author   Colin Moock
 * @date     July 2009
 * @location Toronto, Canada
 */
/**
 * SiON Kaoscillator つかわせていただきました。
 * http://wonderfl.net/code/80621cb517f2691e07f1147272386ff83ecf2ebe
 */

package {
  import flash.display.StageQuality;
  import flash.display.Sprite;
  import flash.display.Shape;
  import flash.display.Graphics;
  import flash.display.Bitmap;
  import flash.display.BitmapData;
  import flash.events.Event;
  import flash.events.MouseEvent;
  import flash.geom.ColorTransform;
  import flash.geom.Rectangle;
  import net.user1.reactor.*;
  import net.user1.logger.Logger;
  import org.si.sion.*;
  import org.si.sion.events.*;
  import org.si.sion.sequencer.SiMMLTrack;
  import org.si.sion.utils.SiONPresetVoice;
  import org.si.sion.utils.Scale;
  import org.si.sound.Arpeggiator;

  [SWF(width = 465,height = 465,backgroundColor = 0x000000,frameRate = 30)]
  // The main application class
  public class UnionRamen extends Sprite {
    // Union objects
    protected var reactor:Reactor;
    protected var room:Room;

    protected const roomID:String = 'wonderfl.desegno.fzmn';
    protected var send:Function;
    protected var list:Array = new Array();
    protected var cursors:Object = new Object();
    protected var line:int = 0;
    protected var screen:BitmapData = new BitmapData(465,465,false,0xff000000);
    protected var canvas:Shape = new Shape();
    protected var trans:ColorTransform = new ColorTransform(1,1,1,9 / 11,0,0,0,0);

    protected var driver:SiONDriver = new SiONDriver();
    protected var preset:SiONPresetVoice = new SiONPresetVoice();
    protected var rythm:SiONData;
    protected var arpeggiator:Arpeggiator;
    protected var controlx:int = 0;
    protected var controly:int = 0;

    // Constructor
    public function UnionRamen() {
      stage.quality = StageQuality.LOW;
      addChild(new Bitmap(screen));
      // Make the UConnection object
      reactor = new Reactor();
      // Run readyListener() when the connection is ready
      reactor.addEventListener(ReactorEvent.READY,readyListener);
      // Connect to Union
      reactor.connect("tryunion.com", 9100);
      reactor.getLog().setLevel(Logger.WARN);

      driver.addEventListener(SiONEvent.STREAM,stream);
      var mml:String = "t132;";
      mml += "%6@0o3l8$c2cc.c.; %6@1o3$rcrc; %6@2v8l16$[crccrrcc]; %6@3v8o3$[rc8r8];";
      mml+="%6@4v8l16o3$aa<a8>a<ga>ararara<e8>;";

      rythm=driver.compile(mml);
      rythm.setVoice(0, preset["valsound.percus1"]);
      rythm.setVoice(1, preset["valsound.percus28"]);
      rythm.setVoice(2, preset["valsound.percus17"]);
      rythm.setVoice(3, preset["valsound.percus23"]);
      rythm.setVoice(4, preset["valsound.bass3"]);

      arpeggiator=new Arpeggiator(new Scale("o1Ajap"),1,[0,1,2,5,4,3]);
      arpeggiator.voice=preset["valsound.lead32"];
      arpeggiator.quantize=4;
      arpeggiator.volume=0.3;
      arpeggiator.noteQuantize=8;
    }

    // Method invoked when the connection is ready
    protected function readyListener(e:ReactorEvent):void {
      // Create the application room
      // use a unique identifier for your app
      room=reactor.getRoomManager().createRoom(roomID);
      room.addEventListener(RoomEvent.JOIN,joined);
      room.addEventListener(RoomEvent.UPDATE_CLIENT_ATTRIBUTE,update);
      room.addEventListener(RoomEvent.REMOVE_CLIENT,removeClient);
      // Join the application room
      room.join();

      driver.play(rythm);

      arpeggiator.noteOn();
      arpeggiator.noteOff();
      arpeggiator.pattern=[0,1,2,5,4,3];
    }

    // Creates the user interface
    protected function buildUI():void {
      var cursor:Cursor = new Cursor();
      cursor.x=465/4;
      cursor.y=465/2;
      list.push(addChild(cursor));
      cursor = new Cursor();
      cursor.x=465/4*3;
      cursor.y=465/2;
      list.push(addChild(cursor));

      arpeggiator.scaleIndex=mouseX*32;
      arpeggiator.play();
    }

    protected function joined(ev:RoomEvent):void {
      buildUI();
      send=reactor.getClientManager().self().setAttribute;
      send('xy',mouseX+':'+mouseY,roomID);
      stage.addEventListener(MouseEvent.MOUSE_MOVE,mouseEventHandler);
      stage.addEventListener(MouseEvent.CLICK,mouseEventHandler);
      addEventListener(Event.ENTER_FRAME,enterFrame);
    }

    protected function removeClient(ev:RoomEvent):void {
      var client:IClient=ev.getClient();
      var id:String=client.getClientID();

      if (! client.isSelf()&&cursors.hasOwnProperty(id)) {
        controlx-=cursors[id].x;
        controly-=cursors[id].y;
        list.splice(list.indexOf(cursors[id]),1);
        removeChild(cursors[id]);
        delete cursors[id];
      }
    }

    protected function update(ev:RoomEvent):void {
      var client:IClient=ev.getClient();
      var attr:Attribute=ev.getChangedAttr();

      if (! client.isSelf()&&attr.name=='xy') {
        var pt:Object=attr.value.match(/^(\d+):(\d+)$/);
        if (! pt) {
          return;
        }
        var tx:int=pt[1];
        var ty:int=pt[2];

        var cursor:Cursor;
        var id:String=ev.getClientID();

        if (cursors.hasOwnProperty(id)) {
          cursor=cursors[id];
        } else {
          cursor = cursors[id] = addChild(new Cursor()) as Cursor;
          list.push(cursor);
        }

        if (attr.oldValue) {
          pt=attr.oldValue.match(/^(\d+):(\d+)$/);
          tx-=int(pt[1]);
          ty-=int(pt[2]);
        }

        cursor.x+=tx;
        cursor.y+=ty;
        controlx+=tx;
        controly+=ty;
      }
    }

    protected function mouseEventHandler(ev:MouseEvent):void {
      switch (ev.type) {
        case MouseEvent.MOUSE_MOVE :
          send('xy',mouseX+':'+mouseY,roomID);
          break;

        case MouseEvent.CLICK :
          line++;
          break;
      }
    }

    protected function enterFrame(ev:Event):void {
      screen.colorTransform(new Rectangle(0,0,465,465),trans);
      var x:int,y:int;
      var mx:int=mouseX;
      var my:int=mouseY;
      var len:int=list.length;
      var cursor:Cursor,t:Cursor;
      var g:Graphics=canvas.graphics;
      g.clear();

      for (var i:int=0; i<len; i++) {
        cursor=list[i];
        var cx:int=cursor.x;
        var cy:int=cursor.y;

        switch (line%4) {
          case 0 :
            x=list[int(Math.random()*len)].x;
            y=list[int(Math.random()*len)].y;
            break;
          case 1 :
            t=list[int(Math.random()*len)];
            x=t.x;
            y=t.y;
            break;
          case 2 :
            x=cx;
            y=cy;
            break;
          default :
            x=y=int(Math.random()*465);
        }

        g.lineStyle(0,0xcccccc*Math.random()|0x111111);
        g.moveTo(cx,cy);
        g.curveTo(x,y,mx,my);
        for (var j:int=i+1; j<len; j++) {
          t=list[j];
          g.moveTo(cx,cy);
          g.curveTo(x,y,t.x,t.y);
        }
        g.endFill();
      }

      screen.draw(canvas);
    }

    protected function stream(ev:SiONEvent):void {
      if (arpeggiator.track&&list.length>1) {
        var l:Number=465;
        var c:int=list.length-1;
        var x:Number = (int((controlx+mouseX)/c) - 16) / l;
        var y:Number = (int((controly+mouseY)/c) - 16) / l;
        if (x<0) {
          x=0;
        } else if (x > 1) {
          x=1;
        }
        if (y<0) {
          y=0;
        } else if (y > 1) {
          y=1;
        }
        arpeggiator.scaleIndex=x*32;
        arpeggiator.noteLength=[0.5,1,1,2,4][int(y*4+0.99)];
      }
    }
  }
}

import flash.display.Shape;
import flash.display.Graphics;
class Cursor extends Shape {
  public function Cursor() {
    var g:Graphics=graphics;
    g.lineStyle(0,0xffffff);
    g.moveTo(-2,0);
    g.lineTo(3,0);
    g.moveTo(0,-2);
    g.lineTo(0,3);
    g.endFill();
  }
}