/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/0BBa
 */

package {
    import flash.ui.Keyboard;
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {

            map = new BitmapData(465,465,false,0);
            //map.noise(23,0,255,7,true);
           
            var i:int;
            
            for (i=0;i<512;i+=1)
            {
              setRect(Math.random()*465,Math.random()*465,Math.random()*32+1,Math.random()*32+1,0xffFFffFF);   
            }
            
            setRect(230-16,230-16,32,32,0xFFffFF);
            
            
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);            
        }//ctor
        
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }
        
        public var map:BitmapData;
        
        public function isWall(ax:Number,ay:Number):Boolean
        { return map.getPixel(ax,ay) < 0xFF; }
        
        public var tempRect:Rectangle = new Rectangle(0,0,7,7);
        public function setRect(ax:Number,ay:Number,aw:Number,ah:Number,c:uint):void
        { var r:Rectangle; r= tempRect;
          r.x=ax;r.y=ay;r.width=aw;r.height=ah;
          map.fillRect(r, c);
        }//setrect
        
        
        public var cx:Number = 230;
        public var cy:Number = 230;
        public var rad:Number = 8;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(2, 0);
            
            graphics.beginBitmapFill(map,null,false,false);
             graphics.drawRect(0,0,465,465);
            graphics.endFill();
            
            
            var ms:Number; ms =4;
            var vx:Number; var vy:Number;
            vx =0; vy = 0;

            if (isKeyDown(Keyboard.UP)) { vy = -ms; }          
            if (isKeyDown(Keyboard.DOWN)) { vy = ms; }          
            if (isKeyDown(Keyboard.LEFT)) { vx = -ms; }          
            if (isKeyDown(Keyboard.RIGHT)) { vx = ms; }          
            
            /*
            if (vx == 0 && vy == 0)
            {
                if (isWall(cx-rad-1,cy)) { vx = 1; }
                if (isWall(cx+rad+1,cy)) { vx = -1; }
                if (isWall(cx,cy-rad-1)) { vy = 1; }
                if (isWall(cx,cy+rad+1)) { vy = -1; }
            }//endif     
            */           
            
            if (vx > 0 && isWall(cx+rad,cy)) { vx = 0;}
            if (vx < 0 && isWall(cx-rad,cy)) { vx = 0;}
            if (vy > 0 && isWall(cx,cy+rad)) { vy = 0;}
            if (vy < 0 && isWall(cx,cy-rad)) { vy = 0;}
            
            var ox:Number; var oy:Number;
            ox = cx; oy = cy;
            
            cx += vx; cy += vy;
            
            if ( isWall(cx+rad, cy) && isWall(cx-rad,cy) 
            && isWall(cx,cy-rad) && isWall(cx,cy+rad)) 
            { cx = ox; cy= oy; }
            
            
            graphics.beginFill(0xff8888ff, 1);
             graphics.drawCircle(cx, cy, rad);
            graphics.endFill();
            
            
        }//onenter
        
        
    }//classend
}

