/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/05kE
 */

// forked from bradsedito's forked from: SoundVisualizer3
// forked from okoi's SoundVisualizer3
//
//    SoundVisualizer3
//        ビリビリビジュアライザー
//    
//    音はTsabeat より拝借
//    http://www.ektoplazm.com/free-music/tsabeat-warp-speed-ep/
//
//
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.MovieClip;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.display.GradientType;
        
    [SWF(width = "465", height = "465")]
    
    /**
     * ...
     * @author okoi
     */
     
public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;    public static const HEIGHT:int = 465;
    
        private var _soundloader:SoundLoader;
        private static var policyPath:String = "http://kouetu.sakura.ne.jp/crossdomain.xml";
        private var _path:String = "http://kouetu.sakura.ne.jp/mujic_page/MIDI-3/futarizake.mp3";

        private var _bigball:BigBall;
        
        private var _elects:/*Elect*/Array;
        
        private var _canvas2:BitmapData;
        private var _canvas:BitmapData;
        
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
//            Security.allowDomain("*");
            Security.loadPolicyFile("http://mutast.heteml.jp/crossdomain.xml");

            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();        

            _canvas2 = new BitmapData(WIDTH, HEIGHT,true, 0);
            addChild( new Bitmap(_canvas2) );
            
            _canvas = new BitmapData(WIDTH, HEIGHT,true, 0);
            addChild( new Bitmap(_canvas) );
            
            _soundloader = new SoundLoader();
            _soundloader.Load( _path );
            
                   
                   
            InitSoundObj();
            
            this.addEventListener(Event.ENTER_FRAME, Update );
            
               
        }    
        private function InitSoundObj() : void
        {
            _bigball = new BigBall();
            _elects = new Array();
            for ( var i:int = 0; i < 512; i++ )
            {
                _elects[_elects.length] = new Elect(360/512 * i);
            }            
        }
        
        public function Update(e:Event) : void
        {
            var i:int;
            var array:Array = _soundloader.GetSpectrumData(true);
            var arrayTotal:Number = 0;
            for ( i = 0; i < 512; i++ )    arrayTotal += array[i];
                        
            for ( i = 0; i < 512; i++ )
            {
                _elects[i].Update( WIDTH / 2, HEIGHT / 2, array[i], arrayTotal / 512 );
            }
            _bigball.Update( arrayTotal / 512 );
            
            _canvas2.lock();
            _canvas2.fillRect( _canvas.rect, 0 );
//            _canvas2.draw( _bigball, new Matrix(1, Math.cos(mouseX), Math.cos(mouseY), 1, WIDTH / 2, HEIGHT / 2) );
            _canvas2.draw( _bigball, new Matrix(1, 0, 0, 1, WIDTH / 2, HEIGHT / 2) );
            _canvas2.applyFilter( _canvas2, _canvas2.rect, new Point(), new BlurFilter(10,10,3) );
            _canvas2.applyFilter( _canvas2, _canvas2.rect, new Point(), new GlowFilter(0xFFFFFF*Math.random(), 0.8, 6, 6, 3) );

            _canvas2.unlock(); 
            
            _canvas.lock();
            _canvas.fillRect( _canvas.rect, 0 );
            for ( i = 0; i < 512; i++ )
            {
                _canvas.draw( _elects[i].shape );
            }            
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), new GlowFilter( 0xFFFF00, 0.8, 10, 10, 2, 3, false, false) );
            _canvas.unlock();
        }
        
    }
    
}
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;    
    import flash.media.SoundChannel;    
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.filters.GlowFilter;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;    
    /**
     * ...
     * @author okoi
     */
    class SoundLoader
    {
        
        private  var _started:Boolean;
        private var sound:Sound;
        private var soundChannel:SoundChannel;
        private var bytes:ByteArray;

        
        public function SoundLoader() 
        {
            _started = false;
        }
        
        public function Load(path:String):void
        {
            sound = new Sound();
            sound.addEventListener( Event.COMPLETE, LoadComplete );
            sound.load( new URLRequest(path), new SoundLoaderContext( 10, true ) );
            
            bytes = new ByteArray();
            _started = false;
        }
        
        private function LoadComplete(e:Event):void
        {
            e.target.removeEventListener( Event.COMPLETE, LoadComplete );
            Start();
        }
        
        private function Start():void
        {
            soundChannel = sound.play( 0, 1000 );
            _started = true;
        }
        
        public    function GetSpectrumData(FFTMode:Boolean = false) : Array
        {
            var i:int;
            var buf:Array = new Array(512);
            if ( !_started )
            {
                for ( i = 0; i < 512; i++ )    buf[i] = 0;
                return    buf;
            }
            
            SoundMixer.computeSpectrum( bytes, FFTMode, 0 );
            bytes.position = 0;
            for ( i = 0; i < 512; i++ )    buf[i] = bytes.readFloat();
            
            return    buf;
        }
        
    }


    /**
     * ...
     * @author okoi
     */
    class BigBall extends Shape
    {
        
        public function BigBall() 
        {
            
        //    filters = [new GlowFilter(0xCCCCFF, 0.7, 20, 20, 2, 3, false, false)];
        }
        
        public function Update(totalRate:Number) : void
        {
            var g:Graphics = graphics;
            
            g.clear();
            g.beginFill(0xFFFFFF, Math.min(totalRate*3+0.1,1));
            g.drawCircle(0, 0, 50 + totalRate * 20);
            g.endFill();
        }
        
    }
    

    /**
     * ...
     * @author okoi
     */
    class Elect
    {
        private static const S_LENGTH:int = 50;
        private static const E_LENGTH:int = 350;
        
        
        private var _shape:Shape;
        public function get shape():Shape { return _shape;    }
        
        private var _zAngle:Number;
        private var _xAngle:Number;
        private var _xAngleSpeed:Number;
        
        public function Elect(angle:Number) 
        {
            _zAngle = angle;
            _xAngle = 0;
            _xAngleSpeed = 0;
            _shape = new Shape();
        }
        
        public function Update(tx:Number, ty:Number, val:Number, totalRate:Number ) : void
        {
            var mat:Matrix3D;
            var i:int;
            var g:Graphics = _shape.graphics;
            var level:int = int(val / 0.1);
            var divide:int
            
            _xAngleSpeed += val;
            _xAngleSpeed *= 0.95;
            _xAngle = (_xAngle + _xAngleSpeed) % 360;
            _zAngle = (_zAngle + 1 + totalRate*5) % 360;
            
            g.clear();
            g.lineStyle( 1, 0xFFFFFF, val );
            for ( i = 0; i < 2 + level; i++ )
            {
                mat = new Matrix3D();
                if ( i == 0 )
                {
                    mat.appendTranslation( S_LENGTH, 0, 0 );
                }else
                {
                    var sx:Number = (E_LENGTH - S_LENGTH) / (level + 1) * i + S_LENGTH;
                    mat.appendTranslation( sx, Math.random()*val*50, Math.random()*val*50 );
                }
                
                mat.appendRotation( _zAngle, Vector3D.Z_AXIS );
                mat.appendRotation( _xAngle, Vector3D.X_AXIS );
                mat.appendTranslation( tx, ty, 0 );
                if ( i == 0 )    g.moveTo( mat.position.x, mat.position.y );
                else              g.lineTo( mat.position.x, mat.position.y );
            }
        }
    }
    